#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://172.31.120.143:4450/admin"
$AdminUser = "admin"
$password = "alaska"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")


# get sites
Write-Output "Site"
Write-Output "----"
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json
foreach ($site in $siteList.data)
{
    Write-Output ("Site  $($site.id): $($site.attributes.name)")
}

$siteID = $siteList.data[0].id

# get users
Write-Output "Users"
Write-Output "-----"
$userList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/users" -Method 'GET' -Headers $authHeader
Write-Output $userList | ConvertTo-Json
foreach ($user in $userList.data)
{
    Write-Output ("User $($user.id): $($user.attributes.loginName)")
}
